#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.LabelPrinterConfig;
using System.Net;
#endregion

namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_LabelPrinterConfig : BaseTest 
	{
		LabelPrinterConfig _testLpc;

		private const int TestTcpPortNumber = 23775;
		private const int TestComPortNumber = 5;
		private const int DefaultTcpPortNumber = 21777;
		private const int DefaultComPortNumber = 4;		

		private static readonly IPAddress TestIPAddress = IPAddress.Parse( "212.65.23.121" );

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			_testLpc = new LabelPrinterConfig();			
		}


		[Test]
		public void Ctor_Pass_1()
		{
			Assert.IsNotNull( _testLpc );
		}

		[Test]
		public void Ctor_Pass_2()
		{
			Assert.AreEqual( 1, _testLpc.BrokenRulesCount );
		}

		[Test]
		public void Ctor_Pass_3()
		{
			Assert.AreEqual( DefaultComPortNumber, _testLpc.ComPortNumber );
		}

		[Test]
		public void Ctor_Pass_4()
		{
			Assert.AreEqual( DefaultTcpPortNumber, _testLpc.ListenerTcpPortNumber );
		}

		[Test]
		public void Ctor_Pass_5()
		{
			Assert.IsTrue( !_testLpc.IsDirty );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions ) ]
		public void Ctor_Fail() 
		{
		}

		[Test]
		public void Ctor_DataRow_Pass_1()
		{
			Assert.IsNotNull( new LabelPrinterConfig( GetTestDataRow() ) );
		}

		[Test]
		public void Ctor_DataRow_Pass_2()
		{
			Assert.IsTrue( !new LabelPrinterConfig( GetTestDataRow() ).IsDirty );
		}

		[Test]
		public void Ctor_DataRow_Pass_3()
		{
			_testLpc = new LabelPrinterConfig( GetTestDataRow() );

			// DataRow is initialized with Test* members data.
			Assert.AreEqual( TestComPortNumber, _testLpc.ComPortNumber );
			Assert.AreEqual( TestTcpPortNumber, _testLpc.ListenerTcpPortNumber );
			Assert.IsTrue( TestIPAddress.Equals( _testLpc.ListenerIPAddress ) );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void Ctor_DataRow_Fail_1()
		{
			new LabelPrinterConfig( null );
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void Ctor_DataRow_Fail_2()
		{
			new LabelPrinterConfig( GetInvalidDataRow() );
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void Ctor_DataRow_Fail_3()
		{
			DataRow _dr = GetTestDataRow();
			_dr[ TABLES.VamcDivision.LabelPrinterComPortNumber ] = -1;
			
			new LabelPrinterConfig( _dr );
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow _dr = GetEmptyDataRow();	
			_testLpc.ListenerIPAddress = TestIPAddress;
			_testLpc.LoadDataRowFromThis( _dr );

			Assert.AreEqual( _testLpc.ComPortNumber, (int)_dr[ TABLES.VamcDivision.LabelPrinterComPortNumber ] );
			Assert.AreEqual( _testLpc.ListenerTcpPortNumber, (int)_dr[ TABLES.VamcDivision.LabelPrinterTcpPortNumber ] );
			Assert.IsTrue( _testLpc.ListenerIPAddress.Equals( IPAddress.Parse( Convert.ToString( _dr[ TABLES.VamcDivision.LabelPrinterIPAddress ] ) ) ) );
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void LoadDataRowFromThis_Fail_1()
		{
			_testLpc.LoadDataRowFromThis( null );
		}

		[Test]
		[ExpectedException(typeof(BusinessObjectException))]
		public void LoadDataRowFromThis_Fail_2()
		{
			_testLpc.ListenerIPAddress = TestIPAddress;
			_testLpc.ComPortNumber = -1;

			_testLpc.LoadDataRowFromThis( GetEmptyDataRow() );
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void LoadDataRowFromThis_Fail_3()
		{
			_testLpc.LoadDataRowFromThis( GetInvalidDataRow() );
		}

		[Test]
		public void ListenerIPAddress_Pass_1()
		{
			_testLpc.ListenerIPAddress = TestIPAddress;
			Assert.IsTrue( _testLpc.ListenerIPAddress.Equals( TestIPAddress ) );
		}

		[Test]
		public void ListenerIPAddress_Pass_2()
		{
			_testLpc.ListenerIPAddress = TestIPAddress;
			Assert.IsTrue( _testLpc.IsDirty );
		}

		[Test]
		public void ListenerIPAddress_Pass_3()
		{
			_testLpc.ListenerIPAddress = TestIPAddress;
			Assert.IsTrue( !_testLpc.IsRuleBroken( BROKEN.ListenerIPAddressNotSet ) );
		}

		[Test]
		public void ListenerIPAddress_Pass_4()
		{
			_testLpc.ListenerIPAddress = TestIPAddress;
			_testLpc.IsDirty = false;
			_testLpc.ListenerIPAddress = TestIPAddress;

			Assert.IsTrue( !_testLpc.IsDirty );
		}

		[Test]
		public void ListenerIPAddress_Fail()
		{
			_testLpc.ListenerIPAddress = null;
			Assert.IsTrue( _testLpc.IsRuleBroken( BROKEN.ListenerIPAddressNotSet ) );
		}

		[Test]
		public void ComPortNumber_Pass_1()
		{
			_testLpc.ComPortNumber =  TestComPortNumber;
			Assert.AreEqual( TestComPortNumber, _testLpc.ComPortNumber );
		}

		[Test]
		public void ComPortNumber_Pass_2()
		{
			_testLpc.ComPortNumber = TestComPortNumber;
			Assert.IsTrue( _testLpc.IsDirty );
		}

		[Test]
		public void ComPortNumber_Pass_3()
		{
			_testLpc.ComPortNumber = TestComPortNumber;
			Assert.IsTrue( !_testLpc.IsRuleBroken( BROKEN.ComPortNumberNotSet ) );
		}

		[Test]
		public void ComPortNumber_Pass_4()
		{
			_testLpc.ComPortNumber = TestComPortNumber;
			Assert.IsTrue( !_testLpc.IsRuleBroken( BROKEN.ComPortNumberOutOfRange ) );
		}

		[Test]
		public void ComPortNumber_Pass_5()
		{
			_testLpc.ComPortNumber = _testLpc.ComPortNumber;
			Assert.IsTrue( !_testLpc.IsDirty );
		}

		[Test]
		public void ComPortNumber_Fail_1()
		{
			_testLpc.ComPortNumber = -1;
			Assert.IsTrue( !_testLpc.IsRuleBroken( BROKEN.ComPortNumberNotSet ) );
		}

		[Test]
		public void ComPortNumber_Fail_2()
		{
			_testLpc.ComPortNumber = -1;
			Assert.IsTrue( _testLpc.IsRuleBroken( BROKEN.ComPortNumberOutOfRange ) );
		}

		[Test]
		public void ComPortNumber_Fail_3()
		{
			_testLpc.ComPortNumber = Common.StNullConvert.Int32Null;
			Assert.IsTrue( _testLpc.IsRuleBroken( BROKEN.ComPortNumberNotSet ) );
		}

		[Test]
		public void ComPortNumber_Fail_4()
		{
			_testLpc.ComPortNumber = Common.StNullConvert.Int32Null;
			Assert.IsTrue( !_testLpc.IsRuleBroken( BROKEN.ComPortNumberOutOfRange ) );
		}

		[Test]
		public void ListenerTcpPortNumber_Pass_1()
		{
			_testLpc.ListenerTcpPortNumber = TestTcpPortNumber;
			Assert.AreEqual( TestTcpPortNumber, _testLpc.ListenerTcpPortNumber );
		}

		[Test]
		public void ListenerTcpPortNumber_Pass_2()
		{
			_testLpc.ListenerTcpPortNumber = TestTcpPortNumber;
			Assert.IsTrue( _testLpc.IsDirty );
		}

		[Test]
		public void ListenerTcpPortNumber_Pass_3()
		{
			_testLpc.ListenerTcpPortNumber = TestTcpPortNumber;
			Assert.IsTrue( !_testLpc.IsRuleBroken( BROKEN.ListenerTcpPortNumberNotSet ) );
		}

		[Test]
		public void ListenerTcpPortNumber_Pass_4()
		{
			_testLpc.ListenerTcpPortNumber = TestTcpPortNumber;
			Assert.IsTrue( !_testLpc.IsRuleBroken( BROKEN.ListenerTcpPortNumberOutOfRange ) );
		}

		[Test]
		public void ListenerTcpPortNumber_Pass_5()
		{
			_testLpc.ListenerTcpPortNumber = _testLpc.ListenerTcpPortNumber;
			Assert.IsTrue( !_testLpc.IsDirty );
		}

		[Test]
		public void ListenerTcpPortNumber_Fail_1()
		{
			_testLpc.ListenerTcpPortNumber = -1;
			Assert.IsTrue( !_testLpc.IsRuleBroken( BROKEN.ListenerTcpPortNumberNotSet ) );
		}

		[Test]
		public void ListenerTcpPortNumber_Fail_2()
		{
			_testLpc.ListenerTcpPortNumber = -1;
			Assert.IsTrue( _testLpc.IsRuleBroken( BROKEN.ListenerTcpPortNumberOutOfRange ) );
		}

		[Test]
		public void ListenerTcpPortNumber_Fail_3()
		{
			_testLpc.ListenerTcpPortNumber = Common.StNullConvert.Int32Null;
			Assert.IsTrue( _testLpc.IsRuleBroken( BROKEN.ListenerTcpPortNumberNotSet ) );
		}

		[Test]
		public void ListenerTcpPortNumber_Fail_4()
		{
			_testLpc.ListenerTcpPortNumber = Common.StNullConvert.Int32Null;
			Assert.IsTrue( !_testLpc.IsRuleBroken( BROKEN.ListenerTcpPortNumberOutOfRange ) );
		}

		private static DataRow GetTestDataRow()
		{
			DataRow _dr = GetEmptyDataRow();
			_dr[ TABLES.VamcDivision.LabelPrinterComPortNumber ] = TestComPortNumber;
			_dr[ TABLES.VamcDivision.LabelPrinterIPAddress ] = TestIPAddress.ToString();
			_dr[ TABLES.VamcDivision.LabelPrinterTcpPortNumber ] = TestTcpPortNumber;

			return _dr;
		}

		private static DataRow GetEmptyDataRow()
		{
			return GetTestDataTable().NewRow();
		}

		private static DataTable GetTestDataTable()
		{
			DataTable _dt = new DataTable();
			_dt.Columns.Add( TABLES.VamcDivision.LabelPrinterComPortNumber, typeof(int) );
			_dt.Columns.Add( TABLES.VamcDivision.LabelPrinterIPAddress, typeof(string) );
			_dt.Columns.Add( TABLES.VamcDivision.LabelPrinterTcpPortNumber, typeof(int) );

			return _dt;
		}

		private static DataRow GetInvalidDataRow()
		{
			DataTable _dt = new DataTable();
			_dt.Columns.Add( "test", typeof(string) );

			return _dt.NewRow();
		}
	}
}
#endif
